#include <stdio.h>

struct dipendente
{
    int codice;
    int meseAssunzione;
    int annoAssunzione;
    int stipendio;
};

int AumentoStipendio(struct dipendente persona, int percentuale);

int main(void)
{
	printf("Ciao! Inserisci i dati dei tuoi dipendenti, ti dirò quali hanno bisogno di un aumento per anzianità.\n");
	
    struct dipendente personaUno;
    printf("Inserisci i dati del primo dipendente (codice, mese di assunzione, anno di assunzione e stipendio):\n");
	scanf("%d%d%d%d", &personaUno.codice, &personaUno.meseAssunzione, &personaUno.annoAssunzione, &personaUno.stipendio);
    
    struct dipendente personaDue;
    printf("Inserisci i dati del secondo dipendente (codice, mese di assunzione, anno di assunzione e stipendio):\n");
    scanf("%d%d%d%d", &personaDue.codice, &personaDue.meseAssunzione, &personaDue.annoAssunzione, &personaDue.stipendio);

    int aumento;
    printf("Inserisci l'aumento che vuoi dare:\n");
    scanf("%d", &aumento);

    personaUno.stipendio = AumentoStipendio(personaUno, aumento);
    personaDue.stipendio = AumentoStipendio(personaDue, aumento);

    if(personaUno.stipendio > 1200)
    {
        printf("%d avrà uno stipendio di %d.\n", personaUno.codice, personaUno.stipendio);
    }
    if(personaDue.stipendio > 1200)
    {
        printf("%d avrà uno stipendio di %d.\n", personaDue.codice, personaDue.stipendio);
    }

	return 0;
}

int AumentoStipendio(struct dipendente persona, int percentuale)
{
    int incremento = 0;

    if((persona.annoAssunzione < 2000) || ((persona.annoAssunzione == 2000) && (persona.meseAssunzione < 5)) )
    {
        incremento = (persona.stipendio * percentuale) / 100;
    }

    return (persona.stipendio + incremento);
}